// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

package net.minecraft.src;

import java.util.List;
import java.util.Random;

// Referenced classes of package net.minecraft.src:
//            Item, EntityPlayer, InventoryPlayer, World, 
//            EntityArrow, ItemStack

public class ItemChantBook extends Item
{

    public ItemChantBook(int i)
    {
        super(i);
        maxStackSize = 1;
        setMaxDamage(9001);
    }
    
    @Override
    public int getIconFromDamage(int i)
    {
    	if (i > 1)
    	{
    		return mod_Mine4Dead.chantBook.iconIndex;
    	}
    	else
    	{
    		return iconIndex;
    	}
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer)
    {
        if (itemstack.getItemDamage()>1  || world.isDaytime())
        {
        	return itemstack;
        }
        if (itemstack.itemID==mod_Mine4Dead.chantDark.shiftedIndex)
        {
        	if (entityplayer.health<7)
        	{
        		return itemstack;
        	}
        	else
        	{
        		entityplayer.health-=6;
        	}        	
        	itemstack=new ItemStack(mod_Mine4Dead.chantBook);
        }
        else
        {
        	itemstack.setItemDamage(9000);
        }
    	if (world.multiplayerWorld)
    	{
    		return itemstack;
    	}
        if (itemstack.itemID==mod_Mine4Dead.chantSmite.shiftedIndex)
        {
        	castSmite(world, entityplayer);
        }
        if (itemstack.itemID==mod_Mine4Dead.chantHeal.shiftedIndex)
        {
        	castHeal(world, entityplayer);
        }
        if (itemstack.itemID==mod_Mine4Dead.chantMind.shiftedIndex)
        {
        	castMind(world, entityplayer);
        }
        if (itemstack.itemID==mod_Mine4Dead.chantBook.shiftedIndex)
        { // Previously chantDark
        	castDark(world, entityplayer);
        }
        entityplayer.worldObj.playSoundAtEntity(entityplayer, "chant", 1.0F, 1.0F / (itemRand.nextFloat() * 0.2F + 0.9F));
        return itemstack;
    }
    
    public void castSmite(World world, EntityPlayer player)
    {
    	AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0D, 0.0D, 0.0D, 0.0D, 0.0D, 0.0D);
    	double r = 10.5D;
    	List ents = player.worldObj.getEntitiesWithinAABBExcludingEntity(null, boundingBox.addCoord(player.posX, player.posY, player.posZ).expand(r, r, r));
    	for (int i = 0; i < ents.size(); i++)
    	{
    		if (ents.get(i) instanceof EntityLiving)
    		{
    			EntityLiving ent = (EntityLiving) ents.get(i);
    			if (ent instanceof EntityM4DMob)
    			{
    				ent.attackEntityFrom(player, 2);
    			}
    			else
    			{
    				ent.heal(1);
    			}
    		}
    	}
    }
    
    public void castHeal(World world, EntityPlayer player)
    {
    	AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0D, 0.0D, 0.0D, 0.0D, 0.0D, 0.0D);
    	double r = 9D;
    	List ents = player.worldObj.getEntitiesWithinAABBExcludingEntity(null, boundingBox.addCoord(player.posX, player.posY, player.posZ).expand(r, r, r));
    	for (int i = 0; i < ents.size(); i++)
    	{
    		if (ents.get(i) instanceof EntityLiving)
    		{
    			EntityLiving ent = (EntityLiving) ents.get(i);
    			if (ent instanceof EntityPlayer || ent instanceof EntityAnimal)
    			{
    				ent.heal(4);
    				for(int j = 0; j < 7; j++)
    		        {
    		            double d = ent.worldObj.rand.nextGaussian() * 0.02D;
    		            double d1 = ent.worldObj.rand.nextGaussian() * 0.02D;
    		            double d2 = ent.worldObj.rand.nextGaussian() * 0.02D;
    		            ent.worldObj.spawnParticle("heart", (ent.posX + (double)(ent.worldObj.rand.nextFloat() * ent.width * 2.0F)) - (double)ent.width, ent.posY + 0.5D + (double)(ent.worldObj.rand.nextFloat() * ent.height), (ent.posZ + (double)(ent.worldObj.rand.nextFloat() * ent.width * 2.0F)) - (double)ent.width, d, d1, d2);
    		        }
    			}
    		}
    	}
    }
    
    public void castMind(World world, EntityPlayer player)
    {
    	AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0D, 0.0D, 0.0D, 0.0D, 0.0D, 0.0D);
    	double r = 6D;
    	List ents = player.worldObj.getEntitiesWithinAABBExcludingEntity(null, boundingBox.addCoord(player.posX, player.posY, player.posZ).expand(r, r, r));
    	for (int i = 0; i < ents.size(); i++)
    	{
    		if (ents.get(i) instanceof EntityLiving)
    		{
    			EntityLiving ent = (EntityLiving) ents.get(i);
    			if (ent instanceof EntityM4DMob)
    			{
    				((EntityM4DMob)ent).chant();
    			}
    			else
    			{
    				if (ent instanceof EntityCreature)
    				{
    					EntityCreature creature = (EntityCreature) ent;
    					int x = (int) (player.posX+(creature.posX - player.posX)*3);
    					int y = (int) (player.posY+(creature.posY - player.posY)*3);
    					int z = (int) (player.posZ+(creature.posZ - player.posZ)*3);
    					creature.pathToEntity=creature.worldObj.getEntityPathToXYZ(creature, x, y, z, mod_Mine4Dead.pathComplexity);
    				}
    			}
    		}
    	}
    }
    
    public void castDark(World world, EntityPlayer player)
    {
    	AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0D, 0.0D, 0.0D, 0.0D, 0.0D, 0.0D);
    	double r = 15D;
    	List ents = player.worldObj.getEntitiesWithinAABBExcludingEntity(null, boundingBox.addCoord(player.posX, player.posY, player.posZ).expand(r, r, r));
    	for (int i = 0; i < ents.size(); i++)
    	{
    		if (!(ents.get(i) instanceof EntityLiving))
    		{
    			ents.remove(i);
    			i--;
    		}
    	}
    	for (int i = 0; i < 13; i++)
    	{
    		if (ents.size()==0)
    		{
    			break;
    		}
    		int index = world.rand.nextInt(ents.size());
    		EntityLiving entityliving = (EntityLiving) ents.get(index);
    		ents.remove(index);
    		entityliving.worldObj.entityJoinedWorld(new EntityLightningBolt(entityliving.worldObj, (double)entityliving.posX, (double)entityliving.posY, (double)entityliving.posZ));
    	}
    }
}
